@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
 */
public data class BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs(
    public val status: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgsBuilder
internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("euslhmhtnqahmlkj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether the existing objects should be replicated. Either `"Enabled"` or `"Disabled"`.
     */
    @JvmName("eafogliuvusdibbm")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs =
        BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModificationsArgs(
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
