@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property role ARN of the IAM role for Amazon S3 to assume when replicating the objects.
 * @property rules Specifies the rules managing the replication (documented below).
 */
public data class BucketReplicationConfigurationArgs(
    public val role: Output<String>,
    public val rules: Output<List<BucketReplicationConfigurationRuleArgs>>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationArgs.builder()
            .role(role.applyValue({ args0 -> args0 }))
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketReplicationConfigurationArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigurationArgsBuilder internal constructor() {
    private var role: Output<String>? = null

    private var rules: Output<List<BucketReplicationConfigurationRuleArgs>>? = null

    /**
     * @param value ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    @JvmName("lykfvfainlvlikif")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Specifies the rules managing the replication (documented below).
     */
    @JvmName("ewqukauphngfiovf")
    public suspend fun rules(`value`: Output<List<BucketReplicationConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("phujeccclewtocbd")
    public suspend fun rules(vararg values: Output<BucketReplicationConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Specifies the rules managing the replication (documented below).
     */
    @JvmName("qobjymghyuyghsys")
    public suspend fun rules(values: List<Output<BucketReplicationConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    @JvmName("ociqxdvgmimfppgg")
    public suspend fun role(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Specifies the rules managing the replication (documented below).
     */
    @JvmName("jomtslbbrghlqaga")
    public suspend fun rules(`value`: List<BucketReplicationConfigurationRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Specifies the rules managing the replication (documented below).
     */
    @JvmName("uoxiadycqisrmhnr")
    public suspend fun rules(argument: List<suspend BucketReplicationConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketReplicationConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Specifies the rules managing the replication (documented below).
     */
    @JvmName("jjikwjrkwnfotvep")
    public suspend fun rules(vararg argument: suspend BucketReplicationConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketReplicationConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Specifies the rules managing the replication (documented below).
     */
    @JvmName("auuscexrlpcoeqkf")
    public suspend fun rules(argument: suspend BucketReplicationConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketReplicationConfigurationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Specifies the rules managing the replication (documented below).
     */
    @JvmName("cgnycfbeatajxbkn")
    public suspend fun rules(vararg values: BucketReplicationConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): BucketReplicationConfigurationArgs = BucketReplicationConfigurationArgs(
        role = role ?: throw PulumiNullFieldException("role"),
        rules = rules ?: throw PulumiNullFieldException("rules"),
    )
}
