@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property deleteMarkerReplicationStatus Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
 * @property destination Specifies the destination for the rule (documented below).
 * @property filter Filter that identifies subset of objects to which the replication rule applies (documented below).
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property prefix Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property priority Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
 * @property sourceSelectionCriteria Specifies special object selection criteria (documented below).
 * @property status Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
 */
public data class BucketReplicationConfigurationRuleArgs(
    public val deleteMarkerReplicationStatus: Output<String>? = null,
    public val destination: Output<BucketReplicationConfigurationRuleDestinationArgs>,
    public val filter: Output<BucketReplicationConfigurationRuleFilterArgs>? = null,
    public val id: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val sourceSelectionCriteria: Output<BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs>? = null,
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleArgs.builder()
            .deleteMarkerReplicationStatus(deleteMarkerReplicationStatus?.applyValue({ args0 -> args0 }))
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .sourceSelectionCriteria(
                sourceSelectionCriteria?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigurationRuleArgsBuilder internal constructor() {
    private var deleteMarkerReplicationStatus: Output<String>? = null

    private var destination: Output<BucketReplicationConfigurationRuleDestinationArgs>? = null

    private var filter: Output<BucketReplicationConfigurationRuleFilterArgs>? = null

    private var id: Output<String>? = null

    private var prefix: Output<String>? = null

    private var priority: Output<Int>? = null

    private var sourceSelectionCriteria:
        Output<BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs>? = null

    private var status: Output<String>? = null

    /**
     * @param value Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
     */
    @JvmName("okfathmutvtphybr")
    public suspend fun deleteMarkerReplicationStatus(`value`: Output<String>) {
        this.deleteMarkerReplicationStatus = value
    }

    /**
     * @param value Specifies the destination for the rule (documented below).
     */
    @JvmName("nsfnksccbglytomi")
    public suspend fun destination(`value`: Output<BucketReplicationConfigurationRuleDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("qedapwwbtccjhbxv")
    public suspend fun filter(`value`: Output<BucketReplicationConfigurationRuleFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("dgxhmseuvxxjynvy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("opldnctiekjuuyyy")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
     */
    @JvmName("mpwmwpteevyvicyb")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Specifies special object selection criteria (documented below).
     */
    @JvmName("klxanltkiqnbkejq")
    public suspend fun sourceSelectionCriteria(`value`: Output<BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs>) {
        this.sourceSelectionCriteria = value
    }

    /**
     * @param value Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
     */
    @JvmName("xeyeeculhmalbwuj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
     */
    @JvmName("phavffouvbmfmpsr")
    public suspend fun deleteMarkerReplicationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteMarkerReplicationStatus = mapped
    }

    /**
     * @param value Specifies the destination for the rule (documented below).
     */
    @JvmName("pvkpsaxpviiudgoc")
    public suspend fun destination(`value`: BucketReplicationConfigurationRuleDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Specifies the destination for the rule (documented below).
     */
    @JvmName("keicsvdoiujuiqhi")
    public suspend fun destination(argument: suspend BucketReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigurationRuleDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("ppvbdnpgqqkirygc")
    public suspend fun filter(`value`: BucketReplicationConfigurationRuleFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("pqkfuxmcjlkfbyru")
    public suspend fun filter(argument: suspend BucketReplicationConfigurationRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BucketReplicationConfigurationRuleFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("iltifnufjyunylsk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("nfithnceuwcoakom")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
     */
    @JvmName("infnrxmqlhbeprql")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies special object selection criteria (documented below).
     */
    @JvmName("ygrhtqukyjohtwxj")
    public suspend fun sourceSelectionCriteria(`value`: BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSelectionCriteria = mapped
    }

    /**
     * @param argument Specifies special object selection criteria (documented below).
     */
    @JvmName("clcwxqnvmoqcddqe")
    public suspend fun sourceSelectionCriteria(argument: suspend BucketReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sourceSelectionCriteria = mapped
    }

    /**
     * @param value Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
     */
    @JvmName("idybwnxdqihadnuh")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketReplicationConfigurationRuleArgs =
        BucketReplicationConfigurationRuleArgs(
            deleteMarkerReplicationStatus = deleteMarkerReplicationStatus,
            destination = destination ?: throw PulumiNullFieldException("destination"),
            filter = filter,
            id = id,
            prefix = prefix,
            priority = priority,
            sourceSelectionCriteria = sourceSelectionCriteria,
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
