@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sseKmsEncryptedObjects Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
 * in `destination` must be specified as well.
 */
public data class BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs(
    public val sseKmsEncryptedObjects: Output<BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs.builder()
            .sseKmsEncryptedObjects(
                sseKmsEncryptedObjects?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs].
 */
@PulumiTagMarker
public class BucketReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder internal constructor() {
    private var sseKmsEncryptedObjects:
        Output<BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>? =
        null

    /**
     * @param value Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("qofmatlqornqkppe")
    public suspend fun sseKmsEncryptedObjects(`value`: Output<BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs>) {
        this.sseKmsEncryptedObjects = value
    }

    /**
     * @param value Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("kixgdrlqqdvrpujo")
    public suspend fun sseKmsEncryptedObjects(`value`: BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param argument Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("jomhcyoexekgtowo")
    public suspend fun sseKmsEncryptedObjects(argument: suspend BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sseKmsEncryptedObjects = mapped
    }

    internal fun build(): BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs =
        BucketReplicationConfigurationRuleSourceSelectionCriteriaArgs(
            sseKmsEncryptedObjects = sseKmsEncryptedObjects,
        )
}
