@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Boolean which indicates if this criteria is enabled.
 */
public data class
BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs(
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs =
        com.pulumi.aws.s3.inputs.BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs].
 */
@PulumiTagMarker
public class
BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Boolean which indicates if this criteria is enabled.
     */
    @JvmName("clbuxouwibgobwyi")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Boolean which indicates if this criteria is enabled.
     */
    @JvmName("jfuficgwjlqcptms")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs =
        BucketReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectsArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
