@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property applyServerSideEncryptionByDefault Single object for setting server-side encryption by default. (documented below)
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 */
public data class BucketServerSideEncryptionConfigurationRuleArgs(
    public val applyServerSideEncryptionByDefault: Output<BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>,
    public val bucketKeyEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationRuleArgs =
        com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationRuleArgs.builder()
            .applyServerSideEncryptionByDefault(
                applyServerSideEncryptionByDefault.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .bucketKeyEnabled(bucketKeyEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketServerSideEncryptionConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketServerSideEncryptionConfigurationRuleArgsBuilder internal constructor() {
    private var applyServerSideEncryptionByDefault:
        Output<BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>? =
        null

    private var bucketKeyEnabled: Output<Boolean>? = null

    /**
     * @param value Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("elibescpymbllkei")
    public suspend fun applyServerSideEncryptionByDefault(`value`: Output<BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>) {
        this.applyServerSideEncryptionByDefault = value
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("xpgxmnbhonvgvwuk")
    public suspend fun bucketKeyEnabled(`value`: Output<Boolean>) {
        this.bucketKeyEnabled = value
    }

    /**
     * @param value Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("prxiudrlrvddghak")
    public suspend fun applyServerSideEncryptionByDefault(`value`: BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyServerSideEncryptionByDefault = mapped
    }

    /**
     * @param argument Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("obaawuubqonviktp")
    public suspend fun applyServerSideEncryptionByDefault(argument: suspend BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.applyServerSideEncryptionByDefault = mapped
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("xlymdvwpvetaxolx")
    public suspend fun bucketKeyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketKeyEnabled = mapped
    }

    internal fun build(): BucketServerSideEncryptionConfigurationRuleArgs =
        BucketServerSideEncryptionConfigurationRuleArgs(
            applyServerSideEncryptionByDefault = applyServerSideEncryptionByDefault ?: throw
                PulumiNullFieldException("applyServerSideEncryptionByDefault"),
            bucketKeyEnabled = bucketKeyEnabled,
        )
}
