@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property applyServerSideEncryptionByDefault Single object for setting server-side encryption by default. See below.
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 */
public data class BucketServerSideEncryptionConfigurationV2RuleArgs(
    public val applyServerSideEncryptionByDefault: Output<BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs>? =
        null,
    public val bucketKeyEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleArgs = com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleArgs.builder()
        .applyServerSideEncryptionByDefault(
            applyServerSideEncryptionByDefault?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .bucketKeyEnabled(bucketKeyEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketServerSideEncryptionConfigurationV2RuleArgs].
 */
@PulumiTagMarker
public class BucketServerSideEncryptionConfigurationV2RuleArgsBuilder internal constructor() {
    private var applyServerSideEncryptionByDefault:
        Output<BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs>? =
        null

    private var bucketKeyEnabled: Output<Boolean>? = null

    /**
     * @param value Single object for setting server-side encryption by default. See below.
     */
    @JvmName("uyodievqosbxckla")
    public suspend fun applyServerSideEncryptionByDefault(`value`: Output<BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs>) {
        this.applyServerSideEncryptionByDefault = value
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("akilpxyvxqxkddsu")
    public suspend fun bucketKeyEnabled(`value`: Output<Boolean>) {
        this.bucketKeyEnabled = value
    }

    /**
     * @param value Single object for setting server-side encryption by default. See below.
     */
    @JvmName("jgchmvctadrdgdwp")
    public suspend fun applyServerSideEncryptionByDefault(`value`: BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyServerSideEncryptionByDefault = mapped
    }

    /**
     * @param argument Single object for setting server-side encryption by default. See below.
     */
    @JvmName("qfoffaiutqvbtxqi")
    public suspend fun applyServerSideEncryptionByDefault(argument: suspend BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgsBuilder.() -> Unit) {
        val toBeMapped =
            BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefaultArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.applyServerSideEncryptionByDefault = mapped
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("jobjlhhhjiuxxgsi")
    public suspend fun bucketKeyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketKeyEnabled = mapped
    }

    internal fun build(): BucketServerSideEncryptionConfigurationV2RuleArgs =
        BucketServerSideEncryptionConfigurationV2RuleArgs(
            applyServerSideEncryptionByDefault = applyServerSideEncryptionByDefault,
            bucketKeyEnabled = bucketKeyEnabled,
        )
}
