@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property role ARN of the IAM role for Amazon S3 to assume when replicating the objects.
 * @property rules Specifies the rules managing the replication (documented below).
 */
public data class BucketV2ReplicationConfigurationArgs(
    public val role: Output<String>,
    public val rules: Output<List<BucketV2ReplicationConfigurationRuleArgs>>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationArgs.builder()
            .role(role.applyValue({ args0 -> args0 }))
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketV2ReplicationConfigurationArgs].
 */
@PulumiTagMarker
public class BucketV2ReplicationConfigurationArgsBuilder internal constructor() {
    private var role: Output<String>? = null

    private var rules: Output<List<BucketV2ReplicationConfigurationRuleArgs>>? = null

    /**
     * @param value ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    @JvmName("aogxxyawtonbioxn")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Specifies the rules managing the replication (documented below).
     */
    @JvmName("bjrqorxnjirhvdpw")
    public suspend fun rules(`value`: Output<List<BucketV2ReplicationConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("qdhwoctnavpqdlxi")
    public suspend fun rules(vararg values: Output<BucketV2ReplicationConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Specifies the rules managing the replication (documented below).
     */
    @JvmName("uhnumnxpseriwiri")
    public suspend fun rules(values: List<Output<BucketV2ReplicationConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     */
    @JvmName("ljjxnjdqcgewcijt")
    public suspend fun role(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Specifies the rules managing the replication (documented below).
     */
    @JvmName("hmpiuesppqstafwe")
    public suspend fun rules(`value`: List<BucketV2ReplicationConfigurationRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Specifies the rules managing the replication (documented below).
     */
    @JvmName("wcbfqndjiowllcks")
    public suspend fun rules(argument: List<suspend BucketV2ReplicationConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Specifies the rules managing the replication (documented below).
     */
    @JvmName("xdrhinaiqibxkjgm")
    public suspend fun rules(vararg argument: suspend BucketV2ReplicationConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Specifies the rules managing the replication (documented below).
     */
    @JvmName("tagikjyhaehqhqfr")
    public suspend fun rules(argument: suspend BucketV2ReplicationConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2ReplicationConfigurationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Specifies the rules managing the replication (documented below).
     */
    @JvmName("qmewxouvxumnenhq")
    public suspend fun rules(vararg values: BucketV2ReplicationConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): BucketV2ReplicationConfigurationArgs = BucketV2ReplicationConfigurationArgs(
        role = role ?: throw PulumiNullFieldException("role"),
        rules = rules ?: throw PulumiNullFieldException("rules"),
    )
}
