@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlTranslations Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
 * @property accountId Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
 * @property bucket ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
 * @property metrics Enables replication metrics (required for S3 RTC) (documented below).
 * @property replicaKmsKeyId Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
 * `sse_kms_encrypted_objects` source selection criteria.
 * @property replicationTimes Enables S3 Replication Time Control (S3 RTC) (documented below).
 * @property storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
 */
public data class BucketV2ReplicationConfigurationRuleDestinationArgs(
    public val accessControlTranslations: Output<List<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs>>? =
        null,
    public val accountId: Output<String>? = null,
    public val bucket: Output<String>,
    public val metrics: Output<List<BucketV2ReplicationConfigurationRuleDestinationMetricArgs>>? =
        null,
    public val replicaKmsKeyId: Output<String>? = null,
    public val replicationTimes: Output<List<BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs>>? = null,
    public val storageClass: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationArgs =
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationArgs.builder()
            .accessControlTranslations(
                accessControlTranslations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .metrics(
                metrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .replicaKmsKeyId(replicaKmsKeyId?.applyValue({ args0 -> args0 }))
            .replicationTimes(
                replicationTimes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageClass(storageClass?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2ReplicationConfigurationRuleDestinationArgs].
 */
@PulumiTagMarker
public class BucketV2ReplicationConfigurationRuleDestinationArgsBuilder internal constructor() {
    private var accessControlTranslations:
        Output<List<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs>>? =
        null

    private var accountId: Output<String>? = null

    private var bucket: Output<String>? = null

    private var metrics: Output<List<BucketV2ReplicationConfigurationRuleDestinationMetricArgs>>? =
        null

    private var replicaKmsKeyId: Output<String>? = null

    private var replicationTimes:
        Output<List<BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs>>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("ernwxnoahstpgpcc")
    public suspend fun accessControlTranslations(`value`: Output<List<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs>>) {
        this.accessControlTranslations = value
    }

    @JvmName("xccbmidlfwffudxt")
    public suspend fun accessControlTranslations(vararg values: Output<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs>) {
        this.accessControlTranslations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("gfyskxsfqsqnltvj")
    public suspend fun accessControlTranslations(values: List<Output<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs>>) {
        this.accessControlTranslations = Output.all(values)
    }

    /**
     * @param value Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
     */
    @JvmName("cqehfpwmweuuyhmb")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
     */
    @JvmName("mfxxdjsbpigbfxtm")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("exopuayqftculaej")
    public suspend fun metrics(`value`: Output<List<BucketV2ReplicationConfigurationRuleDestinationMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("fhdywxfjmcofuqlj")
    public suspend fun metrics(vararg values: Output<BucketV2ReplicationConfigurationRuleDestinationMetricArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("qefogvxfsyxvhowh")
    public suspend fun metrics(values: List<Output<BucketV2ReplicationConfigurationRuleDestinationMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
     * `sse_kms_encrypted_objects` source selection criteria.
     */
    @JvmName("nvtrststynjeswtd")
    public suspend fun replicaKmsKeyId(`value`: Output<String>) {
        this.replicaKmsKeyId = value
    }

    /**
     * @param value Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("qnpsnjuumtlsmcdx")
    public suspend fun replicationTimes(`value`: Output<List<BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs>>) {
        this.replicationTimes = value
    }

    @JvmName("sihdqerhgekuxlji")
    public suspend fun replicationTimes(vararg values: Output<BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs>) {
        this.replicationTimes = Output.all(values.asList())
    }

    /**
     * @param values Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("yabnkwkrapagchss")
    public suspend fun replicationTimes(values: List<Output<BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs>>) {
        this.replicationTimes = Output.all(values)
    }

    /**
     * @param value The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
     */
    @JvmName("nturljlrbtxyhgwi")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("yweqavadvkeakxuy")
    public suspend fun accessControlTranslations(`value`: List<BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlTranslations = mapped
    }

    /**
     * @param argument Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("fiicirrlinrlwfsx")
    public suspend fun accessControlTranslations(argument: List<suspend BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessControlTranslations = mapped
    }

    /**
     * @param argument Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("whilcixlksstcqrk")
    public suspend fun accessControlTranslations(vararg argument: suspend BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessControlTranslations = mapped
    }

    /**
     * @param argument Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("hemharxdshpkgmsg")
    public suspend fun accessControlTranslations(argument: suspend BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.accessControlTranslations = mapped
    }

    /**
     * @param values Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with `account_id` owner override configuration.
     */
    @JvmName("etjoghbolaaqlxcb")
    public suspend fun accessControlTranslations(vararg values: BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessControlTranslations = mapped
    }

    /**
     * @param value Account ID to use for overriding the object owner on replication. Must be used in conjunction with `access_control_translation` override configuration.
     */
    @JvmName("yrmbtdsnjuvqgehi")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
     */
    @JvmName("nyqavucxrfqbjlqp")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("ioofqshjdkmhaywp")
    public suspend fun metrics(`value`: List<BucketV2ReplicationConfigurationRuleDestinationMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("koooolqselofurpv")
    public suspend fun metrics(argument: List<suspend BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("mpkgagryqpdgldyw")
    public suspend fun metrics(vararg argument: suspend BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("fyrcuflbpvjxwxcx")
    public suspend fun metrics(argument: suspend BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values Enables replication metrics (required for S3 RTC) (documented below).
     */
    @JvmName("mnydxsvrvcckxqyk")
    public suspend fun metrics(vararg values: BucketV2ReplicationConfigurationRuleDestinationMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
     * `sse_kms_encrypted_objects` source selection criteria.
     */
    @JvmName("obggjveosudthtex")
    public suspend fun replicaKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaKmsKeyId = mapped
    }

    /**
     * @param value Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("psyowafgyqnngbyl")
    public suspend fun replicationTimes(`value`: List<BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationTimes = mapped
    }

    /**
     * @param argument Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("wkhennyikdkorbem")
    public suspend fun replicationTimes(argument: List<suspend BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicationTimes = mapped
    }

    /**
     * @param argument Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("ucmejvfwgdiucmsl")
    public suspend fun replicationTimes(vararg argument: suspend BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.replicationTimes = mapped
    }

    /**
     * @param argument Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("dnyljilolshkldxt")
    public suspend fun replicationTimes(argument: suspend BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.replicationTimes = mapped
    }

    /**
     * @param values Enables S3 Replication Time Control (S3 RTC) (documented below).
     */
    @JvmName("xpsfrkndbfcbjhgh")
    public suspend fun replicationTimes(vararg values: BucketV2ReplicationConfigurationRuleDestinationReplicationTimeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationTimes = mapped
    }

    /**
     * @param value The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
     */
    @JvmName("hmaueamaomygmtul")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketV2ReplicationConfigurationRuleDestinationArgs =
        BucketV2ReplicationConfigurationRuleDestinationArgs(
            accessControlTranslations = accessControlTranslations,
            accountId = accountId,
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            metrics = metrics,
            replicaKmsKeyId = replicaKmsKeyId,
            replicationTimes = replicationTimes,
            storageClass = storageClass,
        )
}
