@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property sseKmsEncryptedObjects Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
 * in `destination` must be specified as well.
 */
public data class BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs(
    public val sseKmsEncryptedObjects: Output<List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs =
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs.builder()
            .sseKmsEncryptedObjects(
                sseKmsEncryptedObjects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs].
 */
@PulumiTagMarker
public class BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder internal constructor() {
    private var sseKmsEncryptedObjects:
        Output<List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs>>? =
        null

    /**
     * @param value Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("qjjwsltnflsimupr")
    public suspend fun sseKmsEncryptedObjects(`value`: Output<List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs>>) {
        this.sseKmsEncryptedObjects = value
    }

    @JvmName("iaebkgsymnaqapch")
    public suspend fun sseKmsEncryptedObjects(vararg values: Output<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs>) {
        this.sseKmsEncryptedObjects = Output.all(values.asList())
    }

    /**
     * @param values Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("iacdnbobnimytnyy")
    public suspend fun sseKmsEncryptedObjects(values: List<Output<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs>>) {
        this.sseKmsEncryptedObjects = Output.all(values)
    }

    /**
     * @param value Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("lncauxceskosvhiw")
    public suspend fun sseKmsEncryptedObjects(`value`: List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param argument Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("euoophyvxcsgrsyw")
    public suspend fun sseKmsEncryptedObjects(argument: List<suspend BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param argument Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("lrkufnqsgixikpbf")
    public suspend fun sseKmsEncryptedObjects(vararg argument: suspend BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param argument Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("rovxoonassrrtsfy")
    public suspend fun sseKmsEncryptedObjects(argument: suspend BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.sseKmsEncryptedObjects = mapped
    }

    /**
     * @param values Match SSE-KMS encrypted objects (documented below). If specified, `replica_kms_key_id`
     * in `destination` must be specified as well.
     */
    @JvmName("bovbjpqyotktahcf")
    public suspend fun sseKmsEncryptedObjects(vararg values: BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaSseKmsEncryptedObjectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sseKmsEncryptedObjects = mapped
    }

    internal fun build(): BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs =
        BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs(
            sseKmsEncryptedObjects = sseKmsEncryptedObjects,
        )
}
