@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsMasterKeyId AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
 * @property sseAlgorithm Server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
 */
public data class
BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs(
    public val kmsMasterKeyId: Output<String>? = null,
    public val sseAlgorithm: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs =
        com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs.builder()
            .kmsMasterKeyId(kmsMasterKeyId?.applyValue({ args0 -> args0 }))
            .sseAlgorithm(sseAlgorithm.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs].
 */
@PulumiTagMarker
public class
BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder
internal constructor() {
    private var kmsMasterKeyId: Output<String>? = null

    private var sseAlgorithm: Output<String>? = null

    /**
     * @param value AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
     */
    @JvmName("wphixqlfnrbemgpe")
    public suspend fun kmsMasterKeyId(`value`: Output<String>) {
        this.kmsMasterKeyId = value
    }

    /**
     * @param value Server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
     */
    @JvmName("nxejnpeubujbkgdu")
    public suspend fun sseAlgorithm(`value`: Output<String>) {
        this.sseAlgorithm = value
    }

    /**
     * @param value AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
     */
    @JvmName("kpnmnwrldamxkglv")
    public suspend fun kmsMasterKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsMasterKeyId = mapped
    }

    /**
     * @param value Server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
     */
    @JvmName("rjqdjntybcpvpjva")
    public suspend fun sseAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sseAlgorithm = mapped
    }

    internal fun build(): BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs =
        BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs(
            kmsMasterKeyId = kmsMasterKeyId,
            sseAlgorithm = sseAlgorithm ?: throw PulumiNullFieldException("sseAlgorithm"),
        )
}
