@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2VersioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
 * @property mfaDelete Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
 */
public data class BucketV2VersioningArgs(
    public val enabled: Output<Boolean>? = null,
    public val mfaDelete: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2VersioningArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2VersioningArgs =
        com.pulumi.aws.s3.inputs.BucketV2VersioningArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .mfaDelete(mfaDelete?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2VersioningArgs].
 */
@PulumiTagMarker
public class BucketV2VersioningArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var mfaDelete: Output<Boolean>? = null

    /**
     * @param value Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
     */
    @JvmName("xlerifpuwkfxdtnx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
     */
    @JvmName("xhgnwqfbpugyggji")
    public suspend fun mfaDelete(`value`: Output<Boolean>) {
        this.mfaDelete = value
    }

    /**
     * @param value Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
     */
    @JvmName("hwjjnupmdpvcnevs")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
     */
    @JvmName("ykttpcbtflsfssqy")
    public suspend fun mfaDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaDelete = mapped
    }

    internal fun build(): BucketV2VersioningArgs = BucketV2VersioningArgs(
        enabled = enabled,
        mfaDelete = mfaDelete,
    )
}
