@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property suffix Suffix that is appended to a request that is for a directory on the website endpoint.
 * For example, if the suffix is `index.html` and you make a request to `samplebucket/images/`, the data that is returned will be for the object with the key name `images/index.html`.
 * The suffix must not be empty and must not include a slash character.
 */
public data class BucketWebsiteConfigurationV2IndexDocumentArgs(
    public val suffix: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
            .suffix(suffix.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2IndexDocumentArgs].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2IndexDocumentArgsBuilder internal constructor() {
    private var suffix: Output<String>? = null

    /**
     * @param value Suffix that is appended to a request that is for a directory on the website endpoint.
     * For example, if the suffix is `index.html` and you make a request to `samplebucket/images/`, the data that is returned will be for the object with the key name `images/index.html`.
     * The suffix must not be empty and must not include a slash character.
     */
    @JvmName("qoulfaspeuwnnekx")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value Suffix that is appended to a request that is for a directory on the website endpoint.
     * For example, if the suffix is `index.html` and you make a request to `samplebucket/images/`, the data that is returned will be for the object with the key name `images/index.html`.
     * The suffix must not be empty and must not include a slash character.
     */
    @JvmName("atpjufuejrulkldg")
    public suspend fun suffix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2IndexDocumentArgs =
        BucketWebsiteConfigurationV2IndexDocumentArgs(
            suffix = suffix ?: throw PulumiNullFieldException("suffix"),
        )
}
