@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName Name of the host where requests are redirected.
 * @property protocol Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
 */
public data class BucketWebsiteConfigurationV2RedirectAllRequestsToArgs(
    public val hostName: Output<String>,
    public val protocol: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgs.builder()
            .hostName(hostName.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2RedirectAllRequestsToArgs].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2RedirectAllRequestsToArgsBuilder internal constructor() {
    private var hostName: Output<String>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value Name of the host where requests are redirected.
     */
    @JvmName("nlwomgwgahgtroye")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
     */
    @JvmName("ipafudhqfvlocuiw")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Name of the host where requests are redirected.
     */
    @JvmName("hrncfpuubbtvwfay")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
     */
    @JvmName("rchnpojfhbbbpfqe")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2RedirectAllRequestsToArgs =
        BucketWebsiteConfigurationV2RedirectAllRequestsToArgs(
            hostName = hostName ?: throw PulumiNullFieldException("hostName"),
            protocol = protocol,
        )
}
