@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpErrorCodeReturnedEquals HTTP error code when the redirect is applied. If specified with `key_prefix_equals`, then both must be true for the redirect to be applied.
 * @property keyPrefixEquals Object key name prefix when the redirect is applied. If specified with `http_error_code_returned_equals`, then both must be true for the redirect to be applied.
 */
public data class BucketWebsiteConfigurationV2RoutingRuleConditionArgs(
    public val httpErrorCodeReturnedEquals: Output<String>? = null,
    public val keyPrefixEquals: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs.builder()
            .httpErrorCodeReturnedEquals(httpErrorCodeReturnedEquals?.applyValue({ args0 -> args0 }))
            .keyPrefixEquals(keyPrefixEquals?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2RoutingRuleConditionArgs].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2RoutingRuleConditionArgsBuilder internal constructor() {
    private var httpErrorCodeReturnedEquals: Output<String>? = null

    private var keyPrefixEquals: Output<String>? = null

    /**
     * @param value HTTP error code when the redirect is applied. If specified with `key_prefix_equals`, then both must be true for the redirect to be applied.
     */
    @JvmName("hqaccmgckfyftjki")
    public suspend fun httpErrorCodeReturnedEquals(`value`: Output<String>) {
        this.httpErrorCodeReturnedEquals = value
    }

    /**
     * @param value Object key name prefix when the redirect is applied. If specified with `http_error_code_returned_equals`, then both must be true for the redirect to be applied.
     */
    @JvmName("qypchwdnipnjsbgh")
    public suspend fun keyPrefixEquals(`value`: Output<String>) {
        this.keyPrefixEquals = value
    }

    /**
     * @param value HTTP error code when the redirect is applied. If specified with `key_prefix_equals`, then both must be true for the redirect to be applied.
     */
    @JvmName("medwtginxnnnvvxu")
    public suspend fun httpErrorCodeReturnedEquals(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpErrorCodeReturnedEquals = mapped
    }

    /**
     * @param value Object key name prefix when the redirect is applied. If specified with `http_error_code_returned_equals`, then both must be true for the redirect to be applied.
     */
    @JvmName("sebyjpekcbvvqwoe")
    public suspend fun keyPrefixEquals(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefixEquals = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2RoutingRuleConditionArgs =
        BucketWebsiteConfigurationV2RoutingRuleConditionArgs(
            httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals,
            keyPrefixEquals = keyPrefixEquals,
        )
}
