@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.DirectoryBucketLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name [Availability Zone ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#az-ids).
 * @property type Location type. Valid values: `AvailabilityZone`.
 */
public data class DirectoryBucketLocationArgs(
    public val name: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.DirectoryBucketLocationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.DirectoryBucketLocationArgs =
        com.pulumi.aws.s3.inputs.DirectoryBucketLocationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryBucketLocationArgs].
 */
@PulumiTagMarker
public class DirectoryBucketLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value [Availability Zone ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#az-ids).
     */
    @JvmName("njefxnsgfvylkufu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Location type. Valid values: `AvailabilityZone`.
     */
    @JvmName("qmijolnqdhjhrwrq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value [Availability Zone ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#az-ids).
     */
    @JvmName("drgxmdspkxecqxuw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Location type. Valid values: `AvailabilityZone`.
     */
    @JvmName("ymhewfhdtmgfcpyd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DirectoryBucketLocationArgs = DirectoryBucketLocationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type,
    )
}
