@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.GetObjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getObject.
 * @property bucket Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
 * @property checksumMode To retrieve the object's checksum, this argument must be `ENABLED`. If you enable `checksum_mode` and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `ENABLED`
 * @property key Full path to the object inside the bucket
 * @property range
 * @property tags Map of tags assigned to the object.
 * @property versionId Specific version ID of the object returned (defaults to latest version)
 */
public data class GetObjectPlainArgs(
    public val bucket: String,
    public val checksumMode: String? = null,
    public val key: String,
    public val range: String? = null,
    public val tags: Map<String, String>? = null,
    public val versionId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.GetObjectPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.GetObjectPlainArgs =
        com.pulumi.aws.s3.inputs.GetObjectPlainArgs.builder()
            .bucket(bucket.let({ args0 -> args0 }))
            .checksumMode(checksumMode?.let({ args0 -> args0 }))
            .key(key.let({ args0 -> args0 }))
            .range(range?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionId(versionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetObjectPlainArgs].
 */
@PulumiTagMarker
public class GetObjectPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    private var checksumMode: String? = null

    private var key: String? = null

    private var range: String? = null

    private var tags: Map<String, String>? = null

    private var versionId: String? = null

    /**
     * @param value Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     */
    @JvmName("vaxproyngnnvfkxo")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucket = mapped
    }

    /**
     * @param value To retrieve the object's checksum, this argument must be `ENABLED`. If you enable `checksum_mode` and the object is encrypted with KMS, you must have permission to use the `kms:Decrypt` action. Valid values: `ENABLED`
     */
    @JvmName("lgkxyjwonbqxndof")
    public suspend fun checksumMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.checksumMode = mapped
    }

    /**
     * @param value Full path to the object inside the bucket
     */
    @JvmName("xrihducyqmfhrvrn")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("tlfygwjnbmxfdibe")
    public suspend fun range(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.range = mapped
    }

    /**
     * @param value Map of tags assigned to the object.
     */
    @JvmName("kyqubkdlikxvvtuv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the object.
     */
    @JvmName("ifertawqcifxmldv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Specific version ID of the object returned (defaults to latest version)
     */
    @JvmName("dfjlevqeqvvvonfy")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionId = mapped
    }

    internal fun build(): GetObjectPlainArgs = GetObjectPlainArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        checksumMode = checksumMode,
        key = key ?: throw PulumiNullFieldException("key"),
        range = range,
        tags = tags,
        versionId = versionId,
    )
}
