@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accountId ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
 * @property bucketArn Amazon S3 bucket ARN of the destination.
 * @property encryption Contains the type of server-side encryption to use to encrypt the inventory (documented below).
 * @property format Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc&#46;apache&#46;org/) or [`Parquet`](https://parquet.apache.org/).
 * @property prefix Prefix that is prepended to all inventory results.
 */
public data class InventoryDestinationBucketArgs(
    public val accountId: Output<String>? = null,
    public val bucketArn: Output<String>,
    public val encryption: Output<InventoryDestinationBucketEncryptionArgs>? = null,
    public val format: Output<String>,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs =
        com.pulumi.aws.s3.inputs.InventoryDestinationBucketArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(format.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InventoryDestinationBucketArgs].
 */
@PulumiTagMarker
public class InventoryDestinationBucketArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var bucketArn: Output<String>? = null

    private var encryption: Output<InventoryDestinationBucketEncryptionArgs>? = null

    private var format: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
     */
    @JvmName("dcpjivfkkmcnfdrd")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Amazon S3 bucket ARN of the destination.
     */
    @JvmName("csuowcivydnxqleg")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value Contains the type of server-side encryption to use to encrypt the inventory (documented below).
     */
    @JvmName("bmynitniobyolmio")
    public suspend fun encryption(`value`: Output<InventoryDestinationBucketEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc&#46;apache&#46;org/) or [`Parquet`](https://parquet.apache.org/).
     */
    @JvmName("ulyhrlmqsxovkyhd")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Prefix that is prepended to all inventory results.
     */
    @JvmName("bmbshmandifvypkt")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value ID of the account that owns the destination bucket. Recommended to be set to prevent problems if the destination bucket ownership changes.
     */
    @JvmName("xaeocfpehakyvkor")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Amazon S3 bucket ARN of the destination.
     */
    @JvmName("rclrpjmsjaliuudh")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value Contains the type of server-side encryption to use to encrypt the inventory (documented below).
     */
    @JvmName("axygutenasbutbiy")
    public suspend fun encryption(`value`: InventoryDestinationBucketEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Contains the type of server-side encryption to use to encrypt the inventory (documented below).
     */
    @JvmName("noqrtkgdxckjpqpu")
    public suspend fun encryption(argument: suspend InventoryDestinationBucketEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryDestinationBucketEncryptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Specifies the output format of the inventory results. Can be `CSV`, [`ORC`](https://orc&#46;apache&#46;org/) or [`Parquet`](https://parquet.apache.org/).
     */
    @JvmName("heqwflnebfbomeyb")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Prefix that is prepended to all inventory results.
     */
    @JvmName("tbsvnjjonwrcqtub")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): InventoryDestinationBucketArgs = InventoryDestinationBucketArgs(
        accountId = accountId,
        bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
        encryption = encryption,
        format = format ?: throw PulumiNullFieldException("format"),
        prefix = prefix,
    )
}
