@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionSseKmsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyId ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
 */
public data class InventoryDestinationBucketEncryptionSseKmsArgs(
    public val keyId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionSseKmsArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionSseKmsArgs =
        com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionSseKmsArgs.builder()
            .keyId(keyId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InventoryDestinationBucketEncryptionSseKmsArgs].
 */
@PulumiTagMarker
public class InventoryDestinationBucketEncryptionSseKmsArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    /**
     * @param value ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
     */
    @JvmName("eulqhklapnihjwgu")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value ARN of the KMS customer master key (CMK) used to encrypt the inventory file.
     */
    @JvmName("leecgkbcctpdswfk")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    internal fun build(): InventoryDestinationBucketEncryptionSseKmsArgs =
        InventoryDestinationBucketEncryptionSseKmsArgs(
            keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        )
}
