@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property grantee Configuration block for the person being granted permissions. See below.
 * @property permission Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `WRITE`, `WRITE_ACP`, `READ`, `READ_ACP`. See [What permissions can I grant?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#permissions) for more details about what each permission means in the context of buckets.
 */
public data class BucketAclV2AccessControlPolicyGrant(
    public val grantee: BucketAclV2AccessControlPolicyGrantGrantee? = null,
    public val permission: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketAclV2AccessControlPolicyGrant): BucketAclV2AccessControlPolicyGrant = BucketAclV2AccessControlPolicyGrant(
            grantee = javaType.grantee().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketAclV2AccessControlPolicyGrantGrantee.Companion.toKotlin(args0)
                })
            }).orElse(null),
            permission = javaType.permission(),
        )
    }
}
