@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property displayName Display name of the owner.
 * @property id ID of the owner.
 */
public data class BucketAclV2AccessControlPolicyOwner(
    public val displayName: String? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketAclV2AccessControlPolicyOwner): BucketAclV2AccessControlPolicyOwner = BucketAclV2AccessControlPolicyOwner(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
        )
    }
}
