@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedHeaders Set of Headers that are specified in the `Access-Control-Request-Headers` header.
 * @property allowedMethods Set of HTTP methods that you allow the origin to execute. Valid values are `GET`, `PUT`, `HEAD`, `POST`, and `DELETE`.
 * @property allowedOrigins Set of origins you want customers to be able to access the bucket from.
 * @property exposeHeaders Set of headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
 * @property id Unique identifier for the rule. The value cannot be longer than 255 characters.
 * @property maxAgeSeconds Time in seconds that your browser is to cache the preflight response for the specified resource.
 */
public data class BucketCorsConfigurationV2CorsRule(
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>,
    public val allowedOrigins: List<String>,
    public val exposeHeaders: List<String>? = null,
    public val id: String? = null,
    public val maxAgeSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketCorsConfigurationV2CorsRule): BucketCorsConfigurationV2CorsRule = BucketCorsConfigurationV2CorsRule(
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
            allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
            exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            maxAgeSeconds = javaType.maxAgeSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
