@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowedHeaders List of headers allowed.
 * @property allowedMethods One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
 * @property allowedOrigins One or more origins you want customers to be able to access the bucket from.
 * @property exposeHeaders One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
 * @property maxAgeSeconds Specifies time in seconds that browser can cache the response for a preflight request.
 */
public data class BucketCorsRule(
    public val allowedHeaders: List<String>? = null,
    public val allowedMethods: List<String>,
    public val allowedOrigins: List<String>,
    public val exposeHeaders: List<String>? = null,
    public val maxAgeSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketCorsRule): BucketCorsRule =
            BucketCorsRule(
                allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }),
                allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }),
                allowedOrigins = javaType.allowedOrigins().map({ args0 -> args0 }),
                exposeHeaders = javaType.exposeHeaders().map({ args0 -> args0 }),
                maxAgeSeconds = javaType.maxAgeSeconds().map({ args0 -> args0 }).orElse(null),
            )
    }
}
