@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
 * @property permissions List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
 * @property type Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
 * @property uri Uri address to grant for. Used only when `type` is `Group`.
 */
public data class BucketGrant(
    public val id: String? = null,
    public val permissions: List<String>,
    public val type: String,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketGrant): BucketGrant = BucketGrant(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            permissions = javaType.permissions().map({ args0 -> args0 }),
            type = javaType.type(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
