@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property and Configuration block used to apply a logical `AND` to two or more predicates. See below. The Lifecycle Rule will apply to any object matching all the predicates configured inside the `and` block.
 * @property objectSizeGreaterThan Minimum object size (in bytes) to which the rule applies.
 * @property objectSizeLessThan Maximum object size (in bytes) to which the rule applies.
 * @property prefix Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if not specified.
 * @property tag Configuration block for specifying a tag key and value. See below.
 */
public data class BucketLifecycleConfigurationV2RuleFilter(
    public val and: BucketLifecycleConfigurationV2RuleFilterAnd? = null,
    public val objectSizeGreaterThan: String? = null,
    public val objectSizeLessThan: String? = null,
    public val prefix: String? = null,
    public val tag: BucketLifecycleConfigurationV2RuleFilterTag? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleConfigurationV2RuleFilter): BucketLifecycleConfigurationV2RuleFilter = BucketLifecycleConfigurationV2RuleFilter(
            and = javaType.and().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleFilterAnd.Companion.toKotlin(args0)
                })
            }).orElse(null),
            objectSizeGreaterThan = javaType.objectSizeGreaterThan().map({ args0 -> args0 }).orElse(null),
            objectSizeLessThan = javaType.objectSizeLessThan().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleFilterTag.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
