@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property newerNoncurrentVersions Number of noncurrent versions Amazon S3 will retain. Must be a non-zero positive integer.
 * @property noncurrentDays Number of days an object is noncurrent before Amazon S3 can perform the associated action. Must be a positive integer.
 */
public data class BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration(
    public val newerNoncurrentVersions: String? = null,
    public val noncurrentDays: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration): BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration =
            BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration(
                newerNoncurrentVersions = javaType.newerNoncurrentVersions().map({ args0 -> args0 }).orElse(null),
                noncurrentDays = javaType.noncurrentDays().map({ args0 -> args0 }).orElse(null),
            )
    }
}
