@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property date Specifies the date after which you want the corresponding action to take effect.
 * @property days Specifies the number of days after object creation when the specific rule action takes effect.
 * @property storageClass Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
 */
public data class BucketLifecycleRuleTransition(
    public val date: String? = null,
    public val days: Int? = null,
    public val storageClass: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleRuleTransition): BucketLifecycleRuleTransition = BucketLifecycleRuleTransition(
            date = javaType.date().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            storageClass = javaType.storageClass(),
        )
    }
}
