@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property partitionedPrefix Partitioned S3 key for log objects. See below.
 * @property simplePrefix Use the simple format for S3 keys for log objects. To use, set `simple_prefix {}`.
 */
public data class BucketLoggingV2TargetObjectKeyFormat(
    public val partitionedPrefix: BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix? = null,
    public val simplePrefix: BucketLoggingV2TargetObjectKeyFormatSimplePrefix? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLoggingV2TargetObjectKeyFormat): BucketLoggingV2TargetObjectKeyFormat = BucketLoggingV2TargetObjectKeyFormat(
            partitionedPrefix = javaType.partitionedPrefix().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetObjectKeyFormatPartitionedPrefix.Companion.toKotlin(args0)
                })
            }).orElse(null),
            simplePrefix = javaType.simplePrefix().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetObjectKeyFormatSimplePrefix.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
