@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
 * @property rule Object Lock rule in place for this bucket (documented below).
 */
public data class BucketObjectLockConfiguration(
    public val objectLockEnabled: String,
    public val rule: BucketObjectLockConfigurationRule? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketObjectLockConfiguration): BucketObjectLockConfiguration = BucketObjectLockConfiguration(
            objectLockEnabled = javaType.objectLockEnabled(),
            rule = javaType.rule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketObjectLockConfigurationRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
