@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property owner Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html) in the Amazon S3 API Reference. Valid values: `Destination`.
 */
public data class BucketReplicationConfigRuleDestinationAccessControlTranslation(
    public val owner: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRuleDestinationAccessControlTranslation): BucketReplicationConfigRuleDestinationAccessControlTranslation =
            BucketReplicationConfigRuleDestinationAccessControlTranslation(
                owner = javaType.owner(),
            )
    }
}
