@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property status Status of the Replication Time Control. Either `"Enabled"` or `"Disabled"`.
 * @property time Configuration block specifying the time by which replication should be complete for all objects and operations on objects. See below.
 */
public data class BucketReplicationConfigRuleDestinationReplicationTime(
    public val status: String,
    public val time: BucketReplicationConfigRuleDestinationReplicationTimeTime,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRuleDestinationReplicationTime): BucketReplicationConfigRuleDestinationReplicationTime =
            BucketReplicationConfigRuleDestinationReplicationTime(
                status = javaType.status(),
                time = javaType.time().let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestinationReplicationTimeTime.Companion.toKotlin(args0)
                }),
            )
    }
}
