@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property replicaModifications Configuration block that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when `filter` is specified), you can specify this element and set the status to `Enabled` to replicate modifications on replicas.
 * @property sseKmsEncryptedObjects Configuration block for filter information for the selection of Amazon S3 objects encrypted with AWS KMS. If specified, `replica_kms_key_id` in `destination` `encryption_configuration` must be specified as well.
 */
public data class BucketReplicationConfigRuleSourceSelectionCriteria(
    public val replicaModifications: BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModifications? = null,
    public val sseKmsEncryptedObjects: BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjects? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRuleSourceSelectionCriteria): BucketReplicationConfigRuleSourceSelectionCriteria =
            BucketReplicationConfigRuleSourceSelectionCriteria(
                replicaModifications = javaType.replicaModifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleSourceSelectionCriteriaReplicaModifications.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sseKmsEncryptedObjects = javaType.sseKmsEncryptedObjects().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleSourceSelectionCriteriaSseKmsEncryptedObjects.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
