@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property prefix Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property tags A map of tags that identifies subset of objects to which the rule applies.
 * The rule applies only to objects having all the tags in its tagset.
 */
public data class BucketReplicationConfigurationRuleFilter(
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigurationRuleFilter): BucketReplicationConfigurationRuleFilter = BucketReplicationConfigurationRuleFilter(
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
