@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property applyServerSideEncryptionByDefault Single object for setting server-side encryption by default. See below.
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 */
public data class BucketServerSideEncryptionConfigurationV2Rule(
    public val applyServerSideEncryptionByDefault: BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault? = null,
    public val bucketKeyEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketServerSideEncryptionConfigurationV2Rule): BucketServerSideEncryptionConfigurationV2Rule =
            BucketServerSideEncryptionConfigurationV2Rule(
                applyServerSideEncryptionByDefault = javaType.applyServerSideEncryptionByDefault().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketServerSideEncryptionConfigurationV2RuleApplyServerSideEncryptionByDefault.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                bucketKeyEnabled = javaType.bucketKeyEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
