@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property abortIncompleteMultipartUploadDays Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
 * @property enabled Specifies lifecycle rule status.
 * @property expirations Specifies a period in the object's expire. See Expiration below for details.
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property noncurrentVersionExpirations Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
 * @property noncurrentVersionTransitions Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
 * @property prefix Object key prefix identifying one or more objects to which the rule applies.
 * @property tags Specifies object tags key and value.
 * @property transitions Specifies a period in the object's transitions. See Transition below for details.
 */
public data class BucketV2LifecycleRule(
    public val abortIncompleteMultipartUploadDays: Int? = null,
    public val enabled: Boolean,
    public val expirations: List<BucketV2LifecycleRuleExpiration>? = null,
    public val id: String? = null,
    public val noncurrentVersionExpirations: List<BucketV2LifecycleRuleNoncurrentVersionExpiration>? =
        null,
    public val noncurrentVersionTransitions: List<BucketV2LifecycleRuleNoncurrentVersionTransition>? =
        null,
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
    public val transitions: List<BucketV2LifecycleRuleTransition>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2LifecycleRule): BucketV2LifecycleRule = BucketV2LifecycleRule(
            abortIncompleteMultipartUploadDays = javaType.abortIncompleteMultipartUploadDays().map({ args0 ->
                args0
            }).orElse(null),
            enabled = javaType.enabled(),
            expirations = javaType.expirations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2LifecycleRuleExpiration.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            noncurrentVersionExpirations = javaType.noncurrentVersionExpirations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2LifecycleRuleNoncurrentVersionExpiration.Companion.toKotlin(args0)
                })
            }),
            noncurrentVersionTransitions = javaType.noncurrentVersionTransitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2LifecycleRuleNoncurrentVersionTransition.Companion.toKotlin(args0)
                })
            }),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitions = javaType.transitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2LifecycleRuleTransition.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
