@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
 * @property rules Object Lock rule in place for this bucket (documented below).
 */
public data class BucketV2ObjectLockConfiguration(
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled instead
  """,
    )
    public val objectLockEnabled: String? = null,
    @Deprecated(
        message = """
  Use the aws.s3.BucketObjectLockConfigurationV2 resource instead
  """,
    )
    public val rules: List<BucketV2ObjectLockConfigurationRule>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ObjectLockConfiguration): BucketV2ObjectLockConfiguration = BucketV2ObjectLockConfiguration(
            objectLockEnabled = javaType.objectLockEnabled().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2ObjectLockConfigurationRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
