@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property days Number of days that you want to specify for the default retention period.
 * @property mode Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
 * @property years Number of years that you want to specify for the default retention period.
 */
public data class BucketV2ObjectLockConfigurationRuleDefaultRetention(
    public val days: Int? = null,
    public val mode: String,
    public val years: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ObjectLockConfigurationRuleDefaultRetention): BucketV2ObjectLockConfigurationRuleDefaultRetention =
            BucketV2ObjectLockConfigurationRuleDefaultRetention(
                days = javaType.days().map({ args0 -> args0 }).orElse(null),
                mode = javaType.mode(),
                years = javaType.years().map({ args0 -> args0 }).orElse(null),
            )
    }
}
