@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property role ARN of the IAM role for Amazon S3 to assume when replicating the objects.
 * @property rules Specifies the rules managing the replication (documented below).
 */
public data class BucketV2ReplicationConfiguration(
    public val role: String,
    public val rules: List<BucketV2ReplicationConfigurationRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ReplicationConfiguration): BucketV2ReplicationConfiguration = BucketV2ReplicationConfiguration(
            role = javaType.role(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketV2ReplicationConfigurationRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
