@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property owner Specifies the replica ownership. For default and valid values, see [PUT bucket replication](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html) in the Amazon S3 API Reference. The only valid value is `Destination`.
 */
public data class BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation(
    public val owner: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation): BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation =
            BucketV2ReplicationConfigurationRuleDestinationAccessControlTranslation(
                owner = javaType.owner(),
            )
    }
}
