@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property applyServerSideEncryptionByDefaults Single object for setting server-side encryption by default. (documented below)
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 */
public data class BucketV2ServerSideEncryptionConfigurationRule(
    public val applyServerSideEncryptionByDefaults: List<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault>,
    public val bucketKeyEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ServerSideEncryptionConfigurationRule): BucketV2ServerSideEncryptionConfigurationRule =
            BucketV2ServerSideEncryptionConfigurationRule(
                applyServerSideEncryptionByDefaults = javaType.applyServerSideEncryptionByDefaults().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault.Companion.toKotlin(args0)
                    })
                }),
                bucketKeyEnabled = javaType.bucketKeyEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
