@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsMasterKeyId AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of `sse_algorithm` as `aws:kms`. The default `aws/s3` AWS KMS master key is used if this element is absent while the `sse_algorithm` is `aws:kms`.
 * @property sseAlgorithm Server-side encryption algorithm to use. Valid values are `AES256` and `aws:kms`
 */
public data class BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault(
    public val kmsMasterKeyId: String? = null,
    public val sseAlgorithm: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault): BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault =
            BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefault(
                kmsMasterKeyId = javaType.kmsMasterKeyId().map({ args0 -> args0 }).orElse(null),
                sseAlgorithm = javaType.sseAlgorithm(),
            )
    }
}
