@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property mfaDelete Specifies whether MFA delete is enabled in the bucket versioning configuration. Valid values: `Enabled` or `Disabled`.
 * @property status Versioning state of the bucket. Valid values: `Enabled`, `Suspended`, or `Disabled`. `Disabled` should only be used when creating or importing resources that correspond to unversioned S3 buckets.
 */
public data class BucketVersioningV2VersioningConfiguration(
    public val mfaDelete: String? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketVersioningV2VersioningConfiguration): BucketVersioningV2VersioningConfiguration = BucketVersioningV2VersioningConfiguration(
            mfaDelete = javaType.mfaDelete().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
        )
    }
}
