@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property suffix Suffix that is appended to a request that is for a directory on the website endpoint.
 * For example, if the suffix is `index.html` and you make a request to `samplebucket/images/`, the data that is returned will be for the object with the key name `images/index.html`.
 * The suffix must not be empty and must not include a slash character.
 */
public data class BucketWebsiteConfigurationV2IndexDocument(
    public val suffix: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2IndexDocument): BucketWebsiteConfigurationV2IndexDocument = BucketWebsiteConfigurationV2IndexDocument(
            suffix = javaType.suffix(),
        )
    }
}
