@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property condition Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
 * @property redirect Configuration block for redirect information. See below.
 */
public data class BucketWebsiteConfigurationV2RoutingRule(
    public val condition: BucketWebsiteConfigurationV2RoutingRuleCondition? = null,
    public val redirect: BucketWebsiteConfigurationV2RoutingRuleRedirect,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2RoutingRule): BucketWebsiteConfigurationV2RoutingRule = BucketWebsiteConfigurationV2RoutingRule(
            condition = javaType.condition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2RoutingRuleCondition.Companion.toKotlin(args0)
                })
            }).orElse(null),
            redirect = javaType.redirect().let({ args0 ->
                com.pulumi.aws.s3.kotlin.outputs.BucketWebsiteConfigurationV2RoutingRuleRedirect.Companion.toKotlin(args0)
            }),
        )
    }
}
