@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property httpErrorCodeReturnedEquals HTTP error code when the redirect is applied. If specified with `key_prefix_equals`, then both must be true for the redirect to be applied.
 * @property keyPrefixEquals Object key name prefix when the redirect is applied. If specified with `http_error_code_returned_equals`, then both must be true for the redirect to be applied.
 */
public data class BucketWebsiteConfigurationV2RoutingRuleCondition(
    public val httpErrorCodeReturnedEquals: String? = null,
    public val keyPrefixEquals: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2RoutingRuleCondition): BucketWebsiteConfigurationV2RoutingRuleCondition =
            BucketWebsiteConfigurationV2RoutingRuleCondition(
                httpErrorCodeReturnedEquals = javaType.httpErrorCodeReturnedEquals().map({ args0 ->
                    args0
                }).orElse(null),
                keyPrefixEquals = javaType.keyPrefixEquals().map({ args0 -> args0 }).orElse(null),
            )
    }
}
