@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAccountPublicAccessBlock.
 * @property accountId
 * @property blockPublicAcls Whether or not Amazon S3 should block public ACLs for buckets in this account is enabled. Returns as `true` or `false`.
 * @property blockPublicPolicy Whether or not Amazon S3 should block public bucket policies for buckets in this account is enabled. Returns as `true` or `false`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ignorePublicAcls Whether or not Amazon S3 should ignore public ACLs for buckets in this account is enabled. Returns as `true` or `false`.
 * @property restrictPublicBuckets Whether or not Amazon S3 should restrict public bucket policies for buckets in this account is enabled. Returns as `true` or `false`.
 */
public data class GetAccountPublicAccessBlockResult(
    public val accountId: String? = null,
    public val blockPublicAcls: Boolean,
    public val blockPublicPolicy: Boolean,
    public val id: String,
    public val ignorePublicAcls: Boolean,
    public val restrictPublicBuckets: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetAccountPublicAccessBlockResult): GetAccountPublicAccessBlockResult = GetAccountPublicAccessBlockResult(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            blockPublicAcls = javaType.blockPublicAcls(),
            blockPublicPolicy = javaType.blockPublicPolicy(),
            id = javaType.id(),
            ignorePublicAcls = javaType.ignorePublicAcls(),
            restrictPublicBuckets = javaType.restrictPublicBuckets(),
        )
    }
}
