@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDirectoryBuckets.
 * @property arns Bucket ARNs.
 * @property buckets Buckets names.
 * @property id
 */
public data class GetDirectoryBucketsResult(
    public val arns: List<String>,
    public val buckets: List<String>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetDirectoryBucketsResult): GetDirectoryBucketsResult = GetDirectoryBucketsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            buckets = javaType.buckets().map({ args0 -> args0 }),
            id = javaType.id(),
        )
    }
}
