@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getObject.
 * @property arn ARN of the object.
 * @property body Object data (see **limitations above** to understand cases in which this field is actually available)
 * @property bucket
 * @property bucketKeyEnabled (Optional) Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 * @property cacheControl Caching behavior along the request/reply chain.
 * @property checksumCrc32 The base64-encoded, 32-bit CRC32 checksum of the object.
 * @property checksumCrc32c The base64-encoded, 32-bit CRC32C checksum of the object.
 * @property checksumMode
 * @property checksumSha1 The base64-encoded, 160-bit SHA-1 digest of the object.
 * @property checksumSha256 The base64-encoded, 256-bit SHA-256 digest of the object.
 * @property contentDisposition Presentational information for the object.
 * @property contentEncoding What content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.
 * @property contentLanguage Language the content is in.
 * @property contentLength Size of the body in bytes.
 * @property contentType Standard MIME type describing the format of the object data.
 * @property etag [ETag](https://en.wikipedia.org/wiki/HTTP_ETag) generated for the object (an MD5 sum of the object content in case it's not encrypted)
 * @property expiration If the object expiration is configured (see [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)), the field includes this header. It includes the expiry-date and rule-id key value pairs providing object expiration information. The value of the rule-id is URL encoded.
 * @property expires Date and time at which the object is no longer cacheable.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property key
 * @property lastModified Last modified date of the object in RFC1123 format (e.g., `Mon, 02 Jan 2006 15:04:05 MST`)
 * @property metadata Map of metadata stored with the object in S3. Keys are always returned in lowercase.
 * @property objectLockLegalHoldStatus Indicates whether this object has an active [legal hold](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-legal-holds). This field is only returned if you have permission to view an object's legal hold status.
 * @property objectLockMode Object lock [retention mode](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes) currently in place for this object.
 * @property objectLockRetainUntilDate The date and time when this object's object lock will expire.
 * @property range
 * @property serverSideEncryption If the object is stored using server-side encryption (KMS or Amazon S3-managed encryption key), this field includes the chosen encryption and algorithm used.
 * @property sseKmsKeyId If present, specifies the ID of the Key Management Service (KMS) master encryption key that was used for the object.
 * @property storageClass [Storage class](http://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html) information of the object. Available for all objects except for `Standard` storage class objects.
 * @property tags Map of tags assigned to the object.
 * @property versionId Latest version ID of the object returned.
 * @property websiteRedirectLocation If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.
 */
public data class GetObjectResult(
    public val arn: String,
    public val body: String,
    public val bucket: String,
    public val bucketKeyEnabled: Boolean,
    public val cacheControl: String,
    public val checksumCrc32: String,
    public val checksumCrc32c: String,
    public val checksumMode: String? = null,
    public val checksumSha1: String,
    public val checksumSha256: String,
    public val contentDisposition: String,
    public val contentEncoding: String,
    public val contentLanguage: String,
    public val contentLength: Int,
    public val contentType: String,
    public val etag: String,
    public val expiration: String,
    public val expires: String,
    public val id: String,
    public val key: String,
    public val lastModified: String,
    public val metadata: Map<String, String>,
    public val objectLockLegalHoldStatus: String,
    public val objectLockMode: String,
    public val objectLockRetainUntilDate: String,
    public val range: String? = null,
    public val serverSideEncryption: String,
    public val sseKmsKeyId: String,
    public val storageClass: String,
    public val tags: Map<String, String>,
    public val versionId: String,
    public val websiteRedirectLocation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.GetObjectResult): GetObjectResult =
            GetObjectResult(
                arn = javaType.arn(),
                body = javaType.body(),
                bucket = javaType.bucket(),
                bucketKeyEnabled = javaType.bucketKeyEnabled(),
                cacheControl = javaType.cacheControl(),
                checksumCrc32 = javaType.checksumCrc32(),
                checksumCrc32c = javaType.checksumCrc32c(),
                checksumMode = javaType.checksumMode().map({ args0 -> args0 }).orElse(null),
                checksumSha1 = javaType.checksumSha1(),
                checksumSha256 = javaType.checksumSha256(),
                contentDisposition = javaType.contentDisposition(),
                contentEncoding = javaType.contentEncoding(),
                contentLanguage = javaType.contentLanguage(),
                contentLength = javaType.contentLength(),
                contentType = javaType.contentType(),
                etag = javaType.etag(),
                expiration = javaType.expiration(),
                expires = javaType.expires(),
                id = javaType.id(),
                key = javaType.key(),
                lastModified = javaType.lastModified(),
                metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                objectLockLegalHoldStatus = javaType.objectLockLegalHoldStatus(),
                objectLockMode = javaType.objectLockMode(),
                objectLockRetainUntilDate = javaType.objectLockRetainUntilDate(),
                range = javaType.range().map({ args0 -> args0 }).orElse(null),
                serverSideEncryption = javaType.serverSideEncryption(),
                sseKmsKeyId = javaType.sseKmsKeyId(),
                storageClass = javaType.storageClass(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                versionId = javaType.versionId(),
                websiteRedirectLocation = javaType.websiteRedirectLocation(),
            )
    }
}
