@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property sseKms Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
 * @property sseS3 Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
 */
public data class InventoryDestinationBucketEncryption(
    public val sseKms: InventoryDestinationBucketEncryptionSseKms? = null,
    public val sseS3: InventoryDestinationBucketEncryptionSseS3? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.InventoryDestinationBucketEncryption): InventoryDestinationBucketEncryption = InventoryDestinationBucketEncryption(
            sseKms = javaType.sseKms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.InventoryDestinationBucketEncryptionSseKms.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sseS3 = javaType.sseS3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.InventoryDestinationBucketEncryptionSseS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
