@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3control.kotlin

import com.pulumi.aws.s3control.kotlin.outputs.AccessGrantAccessGrantsLocationConfiguration
import com.pulumi.aws.s3control.kotlin.outputs.AccessGrantGrantee
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.s3control.kotlin.outputs.AccessGrantAccessGrantsLocationConfiguration.Companion.toKotlin as accessGrantAccessGrantsLocationConfigurationToKotlin
import com.pulumi.aws.s3control.kotlin.outputs.AccessGrantGrantee.Companion.toKotlin as accessGrantGranteeToKotlin

/**
 * Builder for [AccessGrant].
 */
@PulumiTagMarker
public class AccessGrantResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessGrantArgs = AccessGrantArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessGrantArgsBuilder.() -> Unit) {
        val builder = AccessGrantArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessGrant {
        val builtJavaResource = com.pulumi.aws.s3control.AccessGrant(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessGrant(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an S3 Access Grant.
 * Each access grant has its own ID and gives an IAM user or role or a directory user, or group (the grantee) access to a registered location. You determine the level of access, such as `READ` or `READWRITE`.
 * Before you can create a grant, you must have an S3 Access Grants instance in the same Region as the S3 data.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3control.AccessGrantsInstance("example", {});
 * const exampleAccessGrantsLocation = new aws.s3control.AccessGrantsLocation("example", {
 *     iamRoleArn: exampleAwsIamRole.arn,
 *     locationScope: `s3://${exampleAwsS3Bucket.bucket}/prefixA*`,
 * }, {
 *     dependsOn: [example],
 * });
 * const exampleAccessGrant = new aws.s3control.AccessGrant("example", {
 *     accessGrantsLocationId: exampleAccessGrantsLocation.accessGrantsLocationId,
 *     permission: "READ",
 *     accessGrantsLocationConfiguration: {
 *         s3SubPrefix: "prefixB*",
 *     },
 *     grantee: {
 *         granteeType: "IAM",
 *         granteeIdentifier: exampleAwsIamUser.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3control.AccessGrantsInstance("example")
 * example_access_grants_location = aws.s3control.AccessGrantsLocation("example",
 *     iam_role_arn=example_aws_iam_role["arn"],
 *     location_scope=f"s3://{example_aws_s3_bucket['bucket']}/prefixA*",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * example_access_grant = aws.s3control.AccessGrant("example",
 *     access_grants_location_id=example_access_grants_location.access_grants_location_id,
 *     permission="READ",
 *     access_grants_location_configuration={
 *         "s3_sub_prefix": "prefixB*",
 *     },
 *     grantee={
 *         "grantee_type": "IAM",
 *         "grantee_identifier": example_aws_iam_user["arn"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3Control.AccessGrantsInstance("example");
 *     var exampleAccessGrantsLocation = new Aws.S3Control.AccessGrantsLocation("example", new()
 *     {
 *         IamRoleArn = exampleAwsIamRole.Arn,
 *         LocationScope = $"s3://{exampleAwsS3Bucket.Bucket}/prefixA*",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 *     var exampleAccessGrant = new Aws.S3Control.AccessGrant("example", new()
 *     {
 *         AccessGrantsLocationId = exampleAccessGrantsLocation.AccessGrantsLocationId,
 *         Permission = "READ",
 *         AccessGrantsLocationConfiguration = new Aws.S3Control.Inputs.AccessGrantAccessGrantsLocationConfigurationArgs
 *         {
 *             S3SubPrefix = "prefixB*",
 *         },
 *         Grantee = new Aws.S3Control.Inputs.AccessGrantGranteeArgs
 *         {
 *             GranteeType = "IAM",
 *             GranteeIdentifier = exampleAwsIamUser.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3control"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3control.NewAccessGrantsInstance(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccessGrantsLocation, err := s3control.NewAccessGrantsLocation(ctx, "example", &s3control.AccessGrantsLocationArgs{
 * 			IamRoleArn:    pulumi.Any(exampleAwsIamRole.Arn),
 * 			LocationScope: pulumi.Sprintf("s3://%v/prefixA*", exampleAwsS3Bucket.Bucket),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3control.NewAccessGrant(ctx, "example", &s3control.AccessGrantArgs{
 * 			AccessGrantsLocationId: exampleAccessGrantsLocation.AccessGrantsLocationId,
 * 			Permission:             pulumi.String("READ"),
 * 			AccessGrantsLocationConfiguration: &s3control.AccessGrantAccessGrantsLocationConfigurationArgs{
 * 				S3SubPrefix: pulumi.String("prefixB*"),
 * 			},
 * 			Grantee: &s3control.AccessGrantGranteeArgs{
 * 				GranteeType:       pulumi.String("IAM"),
 * 				GranteeIdentifier: pulumi.Any(exampleAwsIamUser.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3control.AccessGrantsInstance;
 * import com.pulumi.aws.s3control.AccessGrantsLocation;
 * import com.pulumi.aws.s3control.AccessGrantsLocationArgs;
 * import com.pulumi.aws.s3control.AccessGrant;
 * import com.pulumi.aws.s3control.AccessGrantArgs;
 * import com.pulumi.aws.s3control.inputs.AccessGrantAccessGrantsLocationConfigurationArgs;
 * import com.pulumi.aws.s3control.inputs.AccessGrantGranteeArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessGrantsInstance("example");
 *         var exampleAccessGrantsLocation = new AccessGrantsLocation("exampleAccessGrantsLocation", AccessGrantsLocationArgs.builder()
 *             .iamRoleArn(exampleAwsIamRole.arn())
 *             .locationScope(String.format("s3://%s/prefixA*", exampleAwsS3Bucket.bucket()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var exampleAccessGrant = new AccessGrant("exampleAccessGrant", AccessGrantArgs.builder()
 *             .accessGrantsLocationId(exampleAccessGrantsLocation.accessGrantsLocationId())
 *             .permission("READ")
 *             .accessGrantsLocationConfiguration(AccessGrantAccessGrantsLocationConfigurationArgs.builder()
 *                 .s3SubPrefix("prefixB*")
 *                 .build())
 *             .grantee(AccessGrantGranteeArgs.builder()
 *                 .granteeType("IAM")
 *                 .granteeIdentifier(exampleAwsIamUser.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3control:AccessGrantsInstance
 *   exampleAccessGrantsLocation:
 *     type: aws:s3control:AccessGrantsLocation
 *     name: example
 *     properties:
 *       iamRoleArn: ${exampleAwsIamRole.arn}
 *       locationScope: s3://${exampleAwsS3Bucket.bucket}/prefixA*
 *     options:
 *       dependson:
 *         - ${example}
 *   exampleAccessGrant:
 *     type: aws:s3control:AccessGrant
 *     name: example
 *     properties:
 *       accessGrantsLocationId: ${exampleAccessGrantsLocation.accessGrantsLocationId}
 *       permission: READ
 *       accessGrantsLocationConfiguration:
 *         s3SubPrefix: prefixB*
 *       grantee:
 *         granteeType: IAM
 *         granteeIdentifier: ${exampleAwsIamUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import S3 Access Grants using the `account_id` and `access_grant_id`, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:s3control/accessGrant:AccessGrant example 123456789012,04549c5e-2f3c-4a07-824d-2cafe720aa22
 * ```
 */
public class AccessGrant internal constructor(
    override val javaResource: com.pulumi.aws.s3control.AccessGrant,
) : KotlinCustomResource(javaResource, AccessGrantMapper) {
    /**
     * Amazon Resource Name (ARN) of the S3 Access Grant.
     */
    public val accessGrantArn: Output<String>
        get() = javaResource.accessGrantArn().applyValue({ args0 -> args0 })

    /**
     * Unique ID of the S3 Access Grant.
     */
    public val accessGrantId: Output<String>
        get() = javaResource.accessGrantId().applyValue({ args0 -> args0 })

    /**
     * See Location Configuration below for more details.
     */
    public val accessGrantsLocationConfiguration:
        Output<AccessGrantAccessGrantsLocationConfiguration>?
        get() = javaResource.accessGrantsLocationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accessGrantAccessGrantsLocationConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the S3 Access Grants location to with the access grant is giving access.
     */
    public val accessGrantsLocationId: Output<String>
        get() = javaResource.accessGrantsLocationId().applyValue({ args0 -> args0 })

    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The access grant's scope.
     */
    public val grantScope: Output<String>
        get() = javaResource.grantScope().applyValue({ args0 -> args0 })

    /**
     * See Grantee below for more details.
     */
    public val grantee: Output<AccessGrantGrantee>?
        get() = javaResource.grantee().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accessGrantGranteeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The access grant's level of access. Valid values: `READ`, `WRITE`, `READWRITE`.
     */
    public val permission: Output<String>
        get() = javaResource.permission().applyValue({ args0 -> args0 })

    /**
     * If you are creating an access grant that grants access to only one object, set this to `Object`. Valid values: `Object`.
     */
    public val s3PrefixType: Output<String>?
        get() = javaResource.s3PrefixType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AccessGrantMapper : ResourceMapper<AccessGrant> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.s3control.AccessGrant::class == javaResource::class

    override fun map(javaResource: Resource): AccessGrant = AccessGrant(
        javaResource as
            com.pulumi.aws.s3control.AccessGrant,
    )
}

/**
 * @see [AccessGrant].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessGrant].
 */
public suspend fun accessGrant(name: String, block: suspend AccessGrantResourceBuilder.() -> Unit): AccessGrant {
    val builder = AccessGrantResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessGrant].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessGrant(name: String): AccessGrant {
    val builder = AccessGrantResourceBuilder()
    builder.name(name)
    return builder.build()
}
